<?php
class LanguageController { private static $instance = null; private $language = 'en'; private $translations = []; private $availableLanguages = ['en', 'tr', 'de', 'fr', 'br', 'cn', 'es', 'ja', 'ko', 'ru']; private function __construct() { if (isset($_SESSION['language']) && in_array($_SESSION['language'], $this->availableLanguages)) { $this->language = $_SESSION['language']; } else if (isset($_COOKIE['torrent_language']) && in_array($_COOKIE['torrent_language'], $this->availableLanguages)) { $this->language = $_COOKIE['torrent_language']; $_SESSION['language'] = $this->language; } else { $this->language = 'en'; $_SESSION['language'] = 'en'; } $this->loadTranslations(); } public static function getInstance() { if (self::$instance === null) { self::$instance = new self(); } return self::$instance; } private function loadTranslations() { $langFile = LANGUAGES_PATH . '/' . $this->language . '.json'; if (file_exists($langFile)) { $json = file_get_contents($langFile); $this->translations = json_decode($json, true); return true; } if ($this->language !== 'en') { $this->language = 'en'; $_SESSION['language'] = 'en'; return $this->loadTranslations(); } return false; } public function setLanguage($language) { if (in_array($language, $this->availableLanguages)) { $this->language = $language; $_SESSION['language'] = $language; setcookie('torrent_language', $language, time() + (86400 * 30), '/'); return $this->loadTranslations(); } return false; } public function getLanguage() { return $this->language; } public function getAvailableLanguages() { return $this->availableLanguages; } public function translate($key, $params = []) { $keys = explode('.', $key); $value = $this->translations; foreach ($keys as $k) { if (!isset($value[$k])) { return $key; } $value = $value[$k]; } if (is_string($value) && !empty($params)) { foreach ($params as $param => $paramValue) { $value = str_replace('{' . $param . '}', $paramValue, $value); } } return $value; } public function translateForSQL($key, $params = []) { $translation = $this->translate($key, $params); return str_replace("'", "''", $translation); } public function getAllTranslations() { return $this->translations; } public function getTranslationSection($section) { $keys = explode('.', $section); $value = $this->translations; foreach ($keys as $k) { if (!isset($value[$k])) { return null; } $value = $value[$k]; } return $value; } } function t($key, $params = []) { return LanguageController::getInstance()->translate($key, $params); } function t_sql($key, $params = []) { return LanguageController::getInstance()->translateForSQL($key, $params); } 